/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.network.node;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.api.network.INetworkNodeVisitor;
import com.raoulvdberge.refinedstorage.api.network.IWirelessTransmitter;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.NetworkNode;
import com.raoulvdberge.refinedstorage.inventory.item.ItemHandlerUpgrade;
import com.raoulvdberge.refinedstorage.inventory.listener.ListenerNetworkNode;
import com.raoulvdberge.refinedstorage.tile.config.IUpgradeContainer;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class NetworkNodeWirelessTransmitter
extends NetworkNode
implements IWirelessTransmitter,
IUpgradeContainer {
    public static final String ID = "wireless_transmitter";
    private final ItemHandlerUpgrade upgrades = new ItemHandlerUpgrade(4, (Consumer<Integer>)new ListenerNetworkNode(this), 1, 11);

    public NetworkNodeWirelessTransmitter(World world, BlockPos pos) {
        super(world, pos);
    }

    @Override
    public int getEnergyUsage() {
        return RS.INSTANCE.config.wirelessTransmitterUsage + this.upgrades.getEnergyUsage();
    }

    @Override
    public void read(NBTTagCompound tag) {
        super.read(tag);
        StackUtils.readItems((IItemHandlerModifiable)this.upgrades, 0, tag);
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public NBTTagCompound write(NBTTagCompound tag) {
        super.write(tag);
        StackUtils.writeItems((IItemHandler)this.upgrades, 0, tag);
        return tag;
    }

    @Override
    public int getRange() {
        return RS.INSTANCE.config.wirelessTransmitterBaseRange + this.upgrades.getUpgradeCount(1) * RS.INSTANCE.config.wirelessTransmitterRangePerUpgrade + this.upgrades.getUpgradeCount(11) * 1000000;
    }

    @Override
    public BlockPos getOrigin() {
        return this.pos;
    }

    @Override
    public int getDimension() {
        return this.world.field_73011_w.getDimension();
    }

    @Override
    public IItemHandler getDrops() {
        return this.getUpgradeHandler();
    }

    @Override
    public boolean canConduct(@Nullable EnumFacing direction) {
        return EnumFacing.DOWN.equals((Object)direction);
    }

    @Override
    public boolean hasConnectivityState() {
        return true;
    }

    @Override
    public void visit(INetworkNodeVisitor.Operator operator) {
        operator.apply(this.world, this.pos.func_177972_a(EnumFacing.DOWN), EnumFacing.UP);
    }

    @Override
    public ItemHandlerUpgrade getUpgradeHandler() {
        return this.upgrades;
    }
}

